#include "functions.inc"

// 3h 15m 10s @ 1280x1024, AA 0.3, +rad, 327.3 MB peak memory usage
// 5h 10m 12s @ 2048x1536, AA 0.3, +rad, 321.5 MB peak memory usage

#declare r = seed(0);

#declare Radious = 1;
#declare Focal_Blur = 0;
#declare SoftShadows = 0;
#declare LandContour = 0; // Draw contour lines on front HF
#declare FrontHF = 1;
#declare BackHF = 1;
#declare BigTrees = 1;
#declare BigTreeSub = 0; // Display cylinders if no big trees
#declare SmallTrees = 1;
#declare BackTrees = 1;
#declare GroundCover = 1;
#declare Ferns = 1;
#declare Bushes = 1;
#declare Debris = 1;
#declare Rocks = 1;
#declare Lake = 1;
#declare Clouds = 1;
#declare City = 1;
#declare Nettles = 1;
#declare Butterflies = 1; 
#declare Wildflowers = 1;

#include "landscape.inc"
#if ( BigTrees = 1 ) #include "redwood.inc" #end
#if ( SmallTrees = 1 ) #include "frontspruce.inc" #end
#if ( BackTrees = 1 ) #include "backspruce.inc" #end
#if ( GroundCover = 1 ) #include "sorrel.inc" #end
#if ( Rocks = 1 ) #include "rock.inc" #end
#if ( Bushes = 1 )
  #include "shrubleaf.inc"
  #include "shrubfoliage.inc"
  #include "shrub.inc"
#end
#if ( Ferns = 1 ) #include "fern.inc" #end
#if ( Nettles = 1 ) #include "nettle3.inc" #end
#if ( Butterflies = 1 ) #include "butterfly.inc" #end
#if ( Wildflowers = 1 ) #include "wildflower.inc" #include "wildflower2.inc" #end

global_settings {
  assumed_gamma 1.8
  max_trace_level 10
  #if ( Radious = 1 )
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 35
      nearest_count 5
      error_bound 1.8
      recursion_limit 1
      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1
      adc_bailout 0.01/2
      media off
      normal on
      }
  #end
  }


#declare Camera_Location = <0, 100, -250>;
camera {
  location Camera_Location
  look_at <0, 100, 0>
  #if ( Focal_Blur = 1 )
    focal_point <0, 100, -200>
    aperture 1.2
    blur_samples 50
    confidence 0.9
    variance 0.001
  #end
  }

//background { color rgb <0.2, 0.2, 0.3> }

//Sky sphere
sphere { 
  <0, 0, 0>, 1e6
  texture {
    pigment {
      gradient x
      scale 2e6
      translate <-1e6, 0, 0>
      rotate <0, 0, 50>
      rotate <0, -38.7, 0>
      color_map {
        [0.0 rgb <0.5, 0.5, 0.5> ]
        [0.3 rgb <0.7, 0.3, 0.15> ]
        [0.5 rgb <0.2, 0.2, 0.4> ]
        //[0.8 rgb <0.1, 0.1, 0.2> ]
        [1.0 rgb <0.0, 0.0, 0.15> ]
        }
      }
    finish { ambient 2 diffuse 0 }
    }
  hollow on
  no_shadow
  }


//Clouds
#if ( Clouds = 1 )
  union {
    #declare i = 0;
    #while ( i < 8 )
      plane { y, 200+5*i }
      #declare i = i + 1;
    #end
     
    texture {
      finish { ambient 0 diffuse 1 }
      pigment {
        bozo turbulence 1.00 translate 200*y
        color_map {
          [0.6, rgb 1 transmit 1.0]
          [1.0, rgb 1 transmit 0.8]
          }
        scale 0.125
        } 
      scale 1500
      } 
    texture {
      finish { ambient 0 diffuse 1 }
      pigment {
        bozo turbulence 0.35 translate 300*y
        color_map {
          [0.6, rgb 1 transmit 1.0]
          [1.0, rgb 1 transmit 0.8]
          }
        scale 10 warp {turbulence 0.7} scale 1/10
        scale 0.125
      }
      scale 2500
    }
    texture {
      finish { ambient 0 diffuse 1 }
      pigment {
        bozo turbulence 0.35 translate 400*y
        color_map {
          [0.6, rgb 1 transmit 1.0]
          [1.0, rgb 1 transmit 0.8]
          }
        scale 10 warp {turbulence 0.7} scale 1/10
        scale 0.125
      }
      scale 2500
    }
    hollow 
    double_illuminate
    scale 40
    clipped_by { plane { <0, 0, -1>, -500 } } 
    
  }

  //Fog
  fog {
    distance 1500
    color rgb <0.4, 0.4, 0.5>
    fog_type 2
    fog_offset 70
    fog_alt 50
    }
#end


//Redwoods in foreground
#declare r = seed(69);
#if ( BigTrees = 1 )
  object { Make_Redwood( 10+10*rand(r), 3-6*rand(r), 20+10*rand(r), 1-2*rand(r), 30*rand(r), 1-2*rand(r), 16 ) scale 5 translate <-30.5, 75, -200> }
  object { Make_Redwood( 10+10*rand(r), 3-6*rand(r), 20+10*rand(r), 1-2*rand(r), 30*rand(r), 1-2*rand(r), 16 ) scale 4.5 translate <-30, 75, -180> }
  object { Make_Redwood( 11.8716, -2.9889, 23.0683, -0.8862, 6.5747, -0.1212, 16 ) scale 5 translate <-3, 80, -190> }
  object { Make_Redwood( 10+10*rand(r), 3-6*rand(r), 20+10*rand(r), 1-2*rand(r), 30*rand(r), 1-2*rand(r), 16 ) scale 3.5  translate <10, 85, -180> }
  object { Make_Redwood( 15, 3, 23, -0.7, 37, 0.3, 12 ) scale 5.5 translate <15, 90, -210> }
  object { Make_Redwood( 10+10*rand(r), 3-6*rand(r), 20+10*rand(r), 1-2*rand(r), 30*rand(r), 1-2*rand(r), 12 ) scale 3.5 translate <31, 95, -195> }
#else #if ( BigTreeSub = 1 )
  cylinder { <0, -1, 0> <0, 16, 0>, 0.8 scale 0.8*3.5 translate <-30, 80, -200> pigment { rgb <1, 1, 0> } }
  cylinder { <0, -1, 0> <0, 16, 0>, 0.8 scale 0.8*4 translate <-30, 70, -180> pigment { rgb <0, 1, 1> } }
  cylinder { <0, -1, 0> <0, 16, 0>, 0.8 scale 0.8*4.5 translate <-3, 75, -190> pigment { rgb <0, 0, 1> } }
  cylinder { <0, -1, 0> <0, 16, 0>, 0.8 scale 0.8*3  translate <10, 85, -180> pigment { rgb <0, 1, 0> } }
  cylinder { <0, -1, 0> <0, 16, 0>, 0.8 scale 0.8*5.5 translate <15, 90, -210> pigment { rgb <1, 0, 0> } }
  cylinder { <0, -1, 0> <0, 16, 0>, 0.8 scale 0.8*3 translate <31, 95, -195> pigment { rgb <1, 0, 1> } }
#end #end



#if ( Lake = 1 )
difference {
  box { 
    <-250, -50, 0> <500, 0, 400> 
    hollow
    interior { 
      ior 1.33 
      media {
        absorption <0.02, 0.02, 0.005>
        scattering { 3, 0.01 }
        }
      }
    texture { 
      pigment { rgbt <0.9, 0.9, 1.0, 0.96> } 
      finish { 
        //reflection { 0.05, 1.0 falloff 0.1 fresnel on } 
        reflection 0.8
        #if ( Radious = 1 ) ambient 0 #end
        specular 0.8 roughness 0.1
        }
      normal { 
        function { f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) } 
        0.01 scale 0.2 
        }  
      }
    }
  object { Foreground }
  object { Background }
  scale <1, 30, 1>
  
  texture { 
    pigment { 
      granite
      turbulence 0.2
      scale 4
      color_map {
        [0.0 rgb 0.8*<0.7, 0.65, 0.6> ]
        [0.5 rgb <0.262, 0.277, 0.324> ]
        [0.7 rgb <0.383, 0.359, 0.359> ]
        [1.0 rgb <0.504, 0.398, 0.332> ]
        }
      } 
    normal { bumps 0.3 scale 0.01 }
    #if ( Radious = 1 ) finish { ambient 0 } #end
    } 
  texture {
    pigment {
      granite
      scale 9
      color_map {
        [ 0.0 rgbt 1 ]
        [ 0.5 rgbt 1 ]
        [ 1.0 rgbt 0.8*<0.6, 0.4, 0.3, 0> ]
        }
      }
    #if ( Radious = 1 ) finish { ambient 0 } #end
    }
  
  texture {
    pigment {
      gradient y
      scale 30
      translate <0, -30, 0>
      color_map {
        [ 0.0 rgbt 1 ]
        [ 0.9 rgbt 0 ]
        }
      }
    #if ( Radious = 1 ) finish { ambient 0 } #end
    }
  translate <0, -0.2, 0>
  }
#end  

//cylinder { <0, 0, 0> <0, 200, 0>, 1 pigment { rgb <1, 0, 0> } translate <-230, 0, 700> }


// City in distance
#if ( City = 1 )
  #declare City_P = <-270, 85, 850>;
  #declare city_block_count = <8, 8, 0>;
  #declare buildings_per_block = <3, 2, 0>;
  #declare city_transform = transform { scale 0.2 translate City_P }
  #declare city_tileable = true;
  #declare min_building_height = 10;
  #declare max_building_height = 80;
  #declare building_height_falloff = 4;
  #declare building_height_turb = 1.5;
  #declare city_seed = 123456;
  #declare pavement_width = 12;
  #declare building_gap = 12;
   
  #include "DEFAULT.OBJ"
  #include "OFFICES.OBJ"
  #include "FLATS.OBJ"
  #include "HOTELS.OBJ"
  #include "CITY"

  #declare city_block_count = <1, 1, 0>;
  #declare buildings_per_block = <3, 2, 0>;
  #declare city_transform = transform { scale 0.1 }
  #declare city_tileable = false;
  #declare min_building_height = 10;
  #declare max_building_height = 20;
  #declare building_height_falloff = 2;
  #declare building_height_turb = 1.0;
  #declare city_seed = 123456;
  #declare pavement_width = 10;
  #declare building_gap = 4;    
    
  #declare Block = object { #include "CITY" }

  #declare i = 0;
  #while ( i < 300 )
    #declare R = 80+70*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare P = <R*cos(theta)-270, 1000, R*sin(theta)+850>;
    #declare L = trace( Background, P, <0, -1, 0> );
    //#if ( vlength(P-L) < 1000 )
    object {
      Block
      rotate <0, 360*rand(r), 0>
      translate L
      }
    #declare i = i + 1;
  //#end
  #end
#end    



#macro FakeTree(P,S) 
  #local a = <0, 360*rand(r), 0>;
  #local s = S*(0.5+1.7*rand(r));
  triangle { vrotate(<-s, 0, 0>, a)+P, vrotate(<s, 0, 0>, a)+P, vrotate(<0, 3.5*s, 0>, a)+P }
  triangle { vrotate(<-0.5*s, 0, 0.866*s>, a)+P, vrotate(<0.5*s, 0, -0.866*s>, a)+P, vrotate(<0, 3.5*s, 0>, a)+P }
  triangle { vrotate(<0.5*s, 0, 0.866*s>, a)+P, vrotate(<-0.5*s, 0, -0.866*s>, a)+P, vrotate(<0, 3.5*s, 0>, a)+P }
#end

#if ( BackTrees = 1 )
//Trees by city
#declare i = 0;
mesh {
  #while ( i < 2000 )
    #declare R = 150-70*rand(r)*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare S = R/70-8/7;
    #declare P = <R*cos(theta)-270,  1000, R*sin(theta)+850>;
    #declare L = trace( Background, P, <0, -1, 0> );
    FakeTree(L,S)
    #declare i = i + 1;
  #end
  texture { 
    pigment {
      bozo
      turbulence 0.5
      color_map {
        [ 0.0 rgb 0.8*<0.1, 0.6, 0.1> ]
        [ 0.1 rgb 0.8*<0.2, 0.4, 0.0> ]
        [ 0.4 rgb 0.8*<0.3, 0.3, 0.1> ]
        [ 0.8 rgbt 1 ]
        [ 1.0 rgbt 1 ]
        }
      scale <1, 0.3, 1>
      }
    normal { bumps scale 0.1 }
    }
  texture { 
    pigment {
      bozo
      turbulence 0.8
      color_map {
        [ 0.0 rgb 0.8*<0.4, 0.5, 0.2> ]
        [ 0.1 rgb 0.8*<0.3, 0.4, 0.1> ]
        [ 0.3 rgb 0.8*<0.1, 0.5, 0> ]
        [ 0.8 rgbt 1 ]
        [ 1.0 rgbt 1 ]
        }
      scale <1, 0.3, 1>
      }
    normal { bumps scale 0.1 }
    finish { specular 0.5 roughness 0.001 }
    }
  }


//Spruce trees in background
#declare i = 0;
#declare BT = mesh {
  #while ( i < 20000 )
    #declare P = <1800*rand(r)-900, 1000, 700+200-800*rand(r)/**rand(r)*/>;
    #declare L = trace( Background, P, <0, -1, 0> );
    #if ( /*(vlength(P-L) < 1000.2) &*/ (vlength(<-270, 1000, 850>-P) > 150) )
      FakeTree(L,1)
      #declare i = i + 1;
    #end
  #end

  texture { 
    pigment {
      bozo
      turbulence 0.5
      color_map {
        [ 0.0 rgb 0.8*<0.1, 0.6, 0.1> ]
        [ 0.1 rgb 0.8*<0.2, 0.4, 0.0> ]
        [ 0.4 rgb 0.8*<0.3, 0.3, 0.1> ]
        [ 0.8 rgbt 1 ]
        [ 1.0 rgbt 1 ]
        }
      scale <1, 0.3, 1>
      }
    normal { bumps scale 0.1 }
    }
  texture { 
    pigment {
      bozo
      turbulence 0.8
      color_map {
        [ 0.0 rgb 0.8*<0.4, 0.5, 0.2> ]
        [ 0.1 rgb 0.8*<0.3, 0.4, 0.1> ]
        [ 0.3 rgb 0.8*<0.1, 0.5, 0> ]
        [ 0.8 rgbt 1 ]
        [ 1.0 rgbt 1 ]
        }
      scale <1, 0.3, 1>
      }
    normal { bumps scale 0.1 }
    finish { specular 0.5 roughness 0.001 }
    }
  }

#declare i = 0;
#while ( i < 18 )
  object { BT translate <-12.5+25*rand(r), 0, -12.5+25*rand(r)> }
  #declare i = i + 1;
#end

//Spruce trees on left
#declare i = 0;
#declare ST = mesh {
  #while ( i < 700 )
    #declare P = <-550+500*rand(r), 1000, 0+400*rand(r)>;
    #declare L = trace( Foreground, P, <0, -1, 0> );
    #if ( vlength(P-L) < 1000.2 )
      FakeTree(L,1)
      #declare i = i + 1;
    #end
  #end
  texture { 
    pigment {
      bozo
      turbulence 0.5
      color_map {
        [ 0.0 rgb 0.8*<0.1, 0.6, 0.1> ]
        [ 0.1 rgb 0.8*<0.2, 0.4, 0.0> ]
        [ 0.4 rgb 0.8*<0.3, 0.3, 0.1> ]
        [ 0.8 rgbt 1 ]
        [ 1.0 rgbt 1 ]
        }
      scale <1, 0.3, 1>
      }
    normal { bumps scale 0.1 }
    }
  texture { 
    pigment {
      bozo
      turbulence 0.8
      color_map {
        [ 0.0 rgb 0.8*<0.4, 0.5, 0.2> ]
        [ 0.1 rgb 0.8*<0.3, 0.4, 0.1> ]
        [ 0.3 rgb 0.8*<0.1, 0.5, 0> ]
        [ 0.8 rgbt 1 ]
        [ 1.0 rgbt 1 ]
        }
      scale <1, 0.3, 1>
      }
    normal { bumps scale 0.1 }
    finish { specular 0.5 roughness 0.001 }
    }
  }
#declare i = 0;
#while ( i < 10 )
  object { ST translate <-10+20*rand(r), 0, -10+20*rand(r)> }
  #declare i = i + 1;
#end

#end

 


/*cylinder { <-400, 0, 100> <-400, 1000, 100>, 1 pigment { rgb <1, 0, 0> } }
cylinder { <-50, 0, 100> <-50, 1000, 100>, 1 pigment { rgb <1, 0, 0> } }
cylinder { <-400, 0, 300> <-400, 1000, 300>, 1 pigment { rgb <1, 0, 0> } }
cylinder { <-50, 0, 300> <-50, 1000, 300>, 1 pigment { rgb <1, 0, 0> } }
*/

//Smaller trees in foreground
#if ( SmallTrees = 1 )
  //In between big trees on right
  #declare r = seed(3);
  #declare i = 0;
  #while ( i < 30 )
    #declare P = < -15 + 50*rand(r), 1000, -140-60*rand(r)>;
    //Check to see random position doesn't coincide with big trees
    #if ( (vlength(P - <-3,1000,-190>) > 5) & (vlength(P - <10,1000,-180>) > 5) & (vlength(P - <15,1000,-210>) > 5) & (vlength(P - <31,1000,-195>) > 5) )    
      #declare L = trace( Foreground, P, <0, -1, 0> );
      object { 
        FrontSpruce 
        scale (0.8+rand(r))*<22, 30, 22> 
        translate L
        }
      #declare i = i + 1;
    #end
  #end
  //Behind big trees on right
  #declare i = 0;
  #while ( i < 30 )
    #declare P = < -20 + 100*rand(r), 1000, -140+40*rand(r)>;
    #declare L = trace( Foreground, P,  <0, -1, 0> );
    object {
      FrontSpruce
      scale (1+1.2*rand(r))*<22, 30, 22>
      rotate <0, 360*rand(r), 0>
      translate L
      }
    #declare i = i + 1;
  #end
  //On left
  #declare i = 0;
  #while ( i < 10 )
    #declare P = < -40 - 25*rand(r), 1000, -100 - 100*rand(r)>;
    #declare L = trace( Foreground, P, <0, -1, 0> );
    object {
      FrontSpruce
      scale (1+1.2*rand(r))*<22, 30, 22>
      rotate <0, 360*rand(r), 0>
      translate L
      }
    #declare i = i + 1;
  #end
  //Off screen on left, casting shadows
  #declare i = 0;
  #while ( i < 6 )
    #declare P = <0 - 50*rand(r), 1000, -230-20*rand(r)>;
    #declare L = trace( Foreground, P, <0, -1, 0> );
    object {
      FrontSpruce
      no_image
      scale (1+1.5*rand(r))*<22, 30, 22>
      rotate <0, 360*rand(r), 0>
      translate L
      }
    #declare i = i + 1;
  #end

  //Single tree on far right
  object {
    FrontSpruce
    scale 0.8*<22, 30, 22>
    translate <45, 97.42, -180>
    }
#end

//cylinder { <0, 0, 0> <0, 500, 0>, 0.25 pigment { rgb <1, 0, 0> } translate <45, 0, -180> }
//#warning vstr( 3, trace( Foreground, <45, 200, -180>, <0, -1, 0> ), ", ", 0, 3 ) 


//Redwood sorrel groundcover
#if ( GroundCover = 1 )
  #declare i = 0;
  #while ( i < 2500 )
    #declare R = 18*rand(r)*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare P = < -10+R*sin(theta), 1000, -195+1.5*R*cos(theta)>;
    #if ( (vlength(P - <-3, 1000, -190>) > 5) & (vlength(P - <5, 1000, -205>) > 3.5) & (vlength(P - <0, 1000, -208>) > 3) & (vlength(P - <3, 1000, -205>) > 5) )
      #declare L = trace( Foreground, P, <0, -1, 0> );
      #if ( rand(r) > 0.9 )
        object { Redwood_Sorrel_Flower scale 0.005 rotate <0, 360*rand(r), 0> translate L }
      #else
        object { Redwood_Sorrel scale 0.005 rotate <0, 360*rand(r), 0> translate L }
      #end
      #declare i = i + 1;
    #end
  #end
#end


//Fern groundcover
#declare r = seed(314);
#if ( Ferns = 1 )
  #declare i = 0;
  #while ( i < 80 )
    #declare R = 15*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare P = <12+1.5*R*sin(theta), 1000, -214+R*cos(theta)>;
    #if ( (vlength(P - <15, 1000, -210>) > 6) & (vlength(P - <3, 1000, -205>) > 6) & (vlength(P - <25, 1000, -212>) > 2.5) & (vlength(P - <23, 1000, -208>) > 3.5) & (vlength(P - <30, 1000, -200>) > 4) & (vlength(P - <16, 1000, -218>) > 4.5) & (vlength(P*z) > 200) )
      #declare L = trace( Foreground, P, <0, -1, 0> );
      object { 
        Fern 
        translate <0, 1, 0> 
        scale 2*(exp(-0.0015*R*R)+0.5*rand(r))*<1, 0.5, 1> 
        texture {
          pigment { 
            granite
            scale 0.01
            color_map {
              [ 0.0 rgb <0.238, 0.461, 0.195> ]
              [ 0.5 rgb <0.3*0.4*rand(r), 0.4+0.4*rand(r), 0.1+0.2*rand(r)> ]
              [ 1.0 rgb <0.418, 0.574, 0.199> ]
              }
            }
          finish { specular 0.5 roughness 0.01 #if ( Radious = 1 ) ambient 0 #end }
          }
        rotate <0, 360*rand(r), 0> 
        translate L
        }
      #declare i = i + 1;
    #end
  #end
  #declare i = 0;
  #while ( i < 150 )
    #declare R = 35*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare P = <-35+R*sin(theta), 1000, -185+R*cos(theta)>;
    #if ( (vlength(P - <-30, 1000, -180>) > 5) & (vlength(P - <-28, 1000, -190>) > 3.5) & (vlength(P - <-30, 1000, -200>) > 5) )
      #declare L = trace( Foreground, P, <0, -1, 0> );
      object { 
        Fern 
        translate <0, 1, 0> 
        scale 2*(exp(-0.0015*R*R)+0.5*rand(r))*<1, 0.5, 1> 
        texture {
          pigment { 
            granite
            scale 0.01
            color_map {
              [ 0.0 rgb <0.238, 0.461, 0.195> ]
              [ 0.5 rgb <0.3*0.4*rand(r), 0.4+0.4*rand(r), 0.1+0.2*rand(r)> ]
              [ 1.0 rgb <0.418, 0.574, 0.199> ]
              }
            }
          finish { specular 0.5 roughness 0.01 #if ( Radious = 1 ) ambient 0 #end }
          }
        rotate <0, 360*rand(r), 0> 
        translate L
        }
      #declare i = i + 1;
    #end
  #end  
  #declare i = 0;
  #while ( i < 150 )
    #declare R = 35*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare P = <45+R*sin(theta), 1000, -170+R*cos(theta)>;
    #if ( (vlength(P - <30, 1000, -200>) > 5) & (vlength(P - <31, 1000, -195>) > 5) )
      #declare L = trace( Foreground, P, <0, -1, 0> );
      object { 
        Fern 
        translate <0, 1, 0> 
        scale 2*(exp(-0.0015*R*R)+0.5*rand(r))*<1, 0.5, 1> 
        texture {
          pigment { 
            granite
            scale 0.01
            color_map {
              [ 0.0 rgb <0.238, 0.461, 0.195> ]
              [ 0.5 rgb <0.3*0.4*rand(r), 0.4+0.4*rand(r), 0.1+0.2*rand(r)> ]
              [ 1.0 rgb <0.418, 0.574, 0.199> ]
              }
            }
          finish { specular 0.5 roughness 0.01 #if ( Radious = 1 ) ambient 0 #end }
          }
        rotate <0, 360*rand(r), 0> 
        translate L
        }
      #declare i = i + 1;
    #end
  #end  
#end



//Nettles
#declare r = seed(0);
#if ( Nettles = 1 )
  #declare i = 0;
  #while ( i < 100 )
    #declare R = 15*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare P = <10+1.3*R*sin(theta), 1000, -200+R*cos(theta)>;
    #if ( (vlength(P - <-3, 1000, -190>) > 5) & (vlength(P - <3, 1000, -205>) > 5) & (vlength(P - <15, 1000, -210>) > 6) & (vlength(P - <5, 1000, -205>) > 3.5) )   //<-28, 77, -190>
      #declare L = trace( Foreground, P, <0, -1, 0> );
      object { 
        Nettle 
        scale 0.25+0.5*rand(r)
        rotate <0, 360*rand(r), 0> 
        translate L
        }
      #declare i = i + 1;
    #end
  #end  
  #declare i = 0;
  #while ( i < 25 )
    #declare R = 6*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare P = <16+R*sin(theta), 1000, -218+R*cos(theta)>;
    #if ( (vlength(P - <15, 1000, -210>) > 8) )   //<-28, 77, -190>
      #declare L = trace( Foreground, P, <0, -1, 0> );
      object { 
        Nettle 
        scale 0.5+0.3*rand(r)
        rotate <0, 360*rand(r), 0> 
        translate L
        }
      #declare i = i + 1;
    #end
  #end  
  #while ( i < 250 )
    #declare R = 35*rand(r);
    #declare theta = 2*pi*rand(r);
    #declare P = <-55+0.7*R*sin(theta), 1000, -165+1.2*R*cos(theta)>;
    //#if ( (vlength(P - <-3, 1000, -190>) > 5) & (vlength(P - <3, 1000, -205>) > 5) )   //<-28, 77, -190>
      #declare L = trace( Foreground, P, <0, -1, 0> );
      object { 
        Nettle 
        scale 0.25+0.5*rand(r)
        rotate <0, 360*rand(r), 0> 
        translate L
        }
      #declare i = i + 1;
    //#end
  #end  
#end


//Carpet of needles on floor
#declare r = seed(42);
#if ( Debris = 1 )
  #declare i = 0;
  #declare Needles = mesh {
    #while ( i < 200 )
      #declare A = <360*rand(r), 360*rand(r), 360*rand(r)>;
      #declare P = <0.5-rand(r), 0.1*rand(r), 0.5-rand(r)>;
      triangle { 
        vrotate( <-0.015, 0.01, -0.3>, A ) + P 
        vrotate( <0.015, 0.01, -0.3>, A ) + P 
        vrotate( <0, 0.01, 0.3>, A ) + P
        }
      #declare i = i + 1;
    #end
    scale <1, 0.3, 1>
  }
  #declare i = 0;
  #while ( i < 15000 )
    #declare N = <0, 0, 0>;
    #declare P = <-60+120*rand(r), 1000, -140-90*rand(r)>;
    #declare L = trace( Foreground, P, <0, -1, 0>, N );
    #declare X = vlength( x*N );                                                                       
    #declare Y = vlength( y*N );
    #declare Z = vlength( z*N );
    #if ( vlength( P - <3, 1000, -205> ) > 3 )
      object { 
        Needles 
        scale 1.7+1.2*rand(r) 
        translate L+<0, 0.1, 0> 
        texture {
          pigment { rgb <0.55+0.2*rand(r), 0.5+0.1*rand(r), 0.35+0.15*rand(r)> }
          #if ( Radious = 1 ) finish { ambient 0 } #end
          }
        }
      #declare i = i + 1;
    #end
  #end
#end  


//Big rocks in foreground
#declare r = seed(13);
#if ( Rocks = 1 )
  object { Rock(0.1, 0.2, 0.05) scale 5 translate <5, 86, -205> }
  object { Rock(0.15, 0.15, 0.07) scale <6, 3, 6> translate <3, 83.5, -205> }
  object { Rock(0.1, 0.2, 0.05) scale <4, 6, 6> translate <30, 95, -200> }
  object { Rock(0.2, 0.2, 0.05) scale <3, 5, 3> translate <-28, 77, -190> }
#end


//Shrubbery
#declare r = seed(0);
#if ( Bushes = 1 )
  #declare Bush = union {
    object { Shrub }
    object { 
      ShrubFoliage 
      texture { 
        pigment { 
          granite
          scale 0.01
          color_map {
            [ 0.0 rgb <0.668, 0.813, 0.301> ]
            [ 1.0 rgb <0.418, 0.574, 0.199> ]
            }
          }
        //pigment { rgb <0.668, 0.813, 0.301> } 
        finish { specular 0.5 roughness 0.01 #if ( Radious = 1 ) ambient 0 #end }
        }
      }
    scale 0.2
    }
  object { Bush scale 1.3 rotate <0, 360*rand(r), 0> translate <23, 90.95, -208> }
  object { Bush scale 1.0 rotate <0, 360*rand(r), 0> translate <-9, 81.07, -188> }
  object { Bush scale 1.2 rotate <0, 360*rand(r), 0> translate <11, 86.60, -208> }
  object { Bush scale 1.0 rotate <0, 360*rand(r), 0> translate <25, 90.41, -212> }
  object { Bush scale 1.3 rotate <0, 360*rand(r), 0> translate <-22, 76.64, -202> }
  object { Bush scale 1.1 rotate <0, 360*rand(r), 0> translate <12, 87.78, -200> }
#end


//Butterflies
#if ( Butterflies = 1 )
#declare i = 0;
#while ( i < 6 )
  object {
    Butterfly(30+40*rand(r))
    scale 0.3+0.5*rand(r)
    rotate <-30+60*rand(r), 360*rand(r), 0>    
    translate <-20+10*rand(r), 80+15*rand(r), -200-10*rand(r)>
    }
  #declare i = i + 1;
#end
#end

//Wildflowers
#if ( Wildflowers = 1 )
  /*cylinder { <0, 0, 0> <0, 500, 0>, 0.1 pigment { rgb <1, 0, 0> } translate <-10, 0, -210> }
  cylinder { <0, 0, 0> <0, 500, 0>, 0.1 pigment { rgb <1, 0, 0> } translate <3, 0, -209> }
  cylinder { <0, 0, 0> <0, 500, 0>, 0.1 pigment { rgb <1, 0, 0> } translate <2, 0, -210> }
  cylinder { <0, 0, 0> <0, 500, 0>, 0.1 pigment { rgb <1, 0, 0> } translate <-22, 0, -185> }
  #warning vstr( 3, trace( Foreground, <-10, 200, -210>, <0, -1, 0> ), ", ", 0, 3 ) 
  #warning vstr( 3, trace( Foreground, <3, 200, -209>, <0, -1, 0> ), ", ", 0, 3 ) 
  #warning vstr( 3, trace( Foreground, <2, 200, -210>, <0, -1, 0> ), ", ", 0, 3 ) 
  #warning vstr( 3, trace( Foreground, <-22, 200, -185>, <0, -1, 0> ), ", ", 0, 3 ) */
  object { Wildflower scale 2+rand(r) rotate <0, 360*rand(r), 0> translate <-2, 81.462, -213> }
  object { Wildflower scale 2+rand(r) rotate <0, 360*rand(r), 0> translate <-23, 77.269, -191> }
  object { Wildflower scale 2+rand(r) rotate <0, 360*rand(r), 0> translate <-22.5, 76.044, -206> }
  object { Wildflower scale 0.7*(2+rand(r)) rotate <0, 360*rand(r), 0> translate <17.5, 89.598, -219> }

  object { Wildflower2 scale 0.9*(1.3+0.5*rand(r)) rotate <0, 360*rand(r), 0> translate <-10, 79.427, -210> }
  object { Wildflower2 scale 0.9*(1.3+0.5*rand(r)) rotate <0, 360*rand(r), 0> translate <-9, 79.427, -209> }
  object { Wildflower2 scale 0.8*(1.3+0.5*rand(r)) rotate <0, 360*rand(r), 0> translate <3, 84.121, -209> }
  object { Wildflower2 scale 0.8*(1.3+0.5*rand(r)) rotate <0, 360*rand(r), 0> translate <2, 83.644, -210> } 
  object { Wildflower2 scale 0.7*(1.7+0.5*rand(r)) rotate <0, 360*rand(r), 0> translate <-22, 77.432, -185> }
#end

//#warning vstr( 3, trace( Foreground, <-9, 200, -188>, <0, -1, 0> ), ", ", 0, 3 ) 


/*
#declare i = 0;
#while ( i < 12 )
  #declare P = <-10+40*rand(r), 1000, -140-90*rand(r)>;
  #declare L = trace( Foreground, P, <0, -1, 0> );
  object { Bush scale 0.8 + 1*rand(r) translate L }
  #declare i = i + 1;
#end
  */

light_source { 
  <-10000, 10000, -8000> 
  rgb <1.28, 1.3, 1.0> 
  #if ( SoftShadows = 1 )
    area_light 100*<0, 1, 0>, 100*<0.492, 0.000, -0.615>, 3, 3
    adaptive 1
    jitter
  #end
  }
//light_source { Camera_Location rgb 0.2 }
//light_source { <-10, 20, -20> rgb 0.4 }
//light_source { <10, -2, -20> rgb 0.4 }